<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PerformanceInterceptor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import javax.sql.DataSource;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import java.util.Properties;
import org.springframework.context.annotation.Primary;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.jdbc.DataSourceBuilder;
import ${pub.getPKGCodeName()}.config.liquibase.IProperties;
import ${pub.getPKGCodeName()}.config.liquibase.MasterProperties;
import ${pub.getPKGCodeName()}.config.liquibase.TempMasterProperties;
import org.springframework.beans.factory.annotation.Autowired;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.util.StringUtils;
import com.alibaba.druid.pool.DruidDataSource;
import org.mybatis.spring.batch.MyBatisCursorItemReader;
import org.apache.ibatis.session.SqlSessionFactory;

@Configuration
public class ${pub.getCodeName()?lower_case}Conf {

    @Bean
    public PerformanceInterceptor performanceInterceptor() {
        PerformanceInterceptor performanceInterceptor = new PerformanceInterceptor();
        /*<!--SQL是否格式化 默认false-->*/
        performanceInterceptor.setFormat(true);
        return performanceInterceptor;
    }
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }
    /**
     * 屏蔽json序列化对象属性为空的错误
     * @return
     */
    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
     /**
     * 多数据源切换
     * @return
     */
    @Bean
    public DatabaseIdProvider getDatabaseIdProvider() {
        DatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties p = new Properties();
        p.setProperty("Oracle", "oracle");
        p.setProperty("MySQL", "mysql");
        p.setProperty("DM", "oracle");//达梦数据库使用oracle模式
        <#if sysrun.getPSDBDevInst()??>
            <#assign dbinst = sysrun.getPSDBDevInst()>
         p.setProperty("H2", "${dbinst.getDBType()?lower_case?replace("mysql5","mysql")}");//根据当前运行的数据库设置h2对应的databaseid
        </#if>
        databaseIdProvider.setProperties(p);
        return databaseIdProvider;
    }
   /**
     * 主数据源版本管理
     * @param
     * @return
     */
    @Bean
    public SpringLiquibase masterliquibase(MasterProperties masterProperties) {
        return LiquibaseInit(masterProperties);
    }
    /**
     * 临时数据源版本管理
     * @param
     * @return
     */
    @Bean
    public SpringLiquibase tempMasterliquibase(TempMasterProperties tempMasterProperties) {
        return LiquibaseInit(tempMasterProperties);
    }
    /**
     * liquibase初始化数据库
     * @param properties
     * @return
     */
   private SpringLiquibase LiquibaseInit(IProperties properties){
       DruidDataSource druidDataSource = new DruidDataSource();
       druidDataSource.setUsername(properties.getUsername());
       druidDataSource.setPassword(properties.getPassword());
       druidDataSource.setUrl(properties.getUrl());

       SpringLiquibase liquibase = new SpringLiquibase();
       liquibase.setDataSource(druidDataSource);
       liquibase.setChangeLog(getChangelog(properties.getIsSyncDBSchema(),properties.getConf()));
       liquibase.setContexts("development,test,production");
       liquibase.setShouldRun(true);
       liquibase.setDefaultSchema(properties.getDefaultSchema());
       return liquibase;
   }
    /**
     * 获取数据库差异文件
     * @param isSyncDBSchema  是否同步表结构
     * @param conf  //liquibase配置文件
     * @return
     */
    private String getChangelog(String isSyncDBSchema,String conf){
        String defaultChangelog="classpath:liquibase/empty.xml";

        if((!StringUtils.isEmpty(isSyncDBSchema))&&(!StringUtils.isEmpty(conf))){
            if(isSyncDBSchema.toLowerCase().equals("true"))
                defaultChangelog=conf;
        }
            return defaultChangelog;
    }
    /**
     * mybatis游标查询 MyBatisCursorItemReader
     * @param sqlSessionFactory
     * @return
     */
    @Bean
    public MyBatisCursorItemReader myMyBatisCursorItemReader(SqlSessionFactory sqlSessionFactory) {
        MyBatisCursorItemReader  reader =new MyBatisCursorItemReader();
        reader.setQueryId("");
        reader.setSqlSessionFactory(sqlSessionFactory);
        return reader;
    }
<#if sys.hasPSWFEngineType("ACTIVITI")>
	@Bean
	public org.activiti.spring.SpringProcessEngineConfiguration processEngineConfiguration(HibernateTransactionManager transactionManager, DataSource dataSource) {
		org.activiti.spring.SpringProcessEngineConfiguration processEngineConfiguration = new org.activiti.spring.SpringProcessEngineConfiguration();
		processEngineConfiguration.setDataSource(dataSource);
		processEngineConfiguration.setTransactionManager(transactionManager);
		processEngineConfiguration.setDatabaseSchemaUpdate("true");
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		Resource[] resources = null;
		try {
			resources = resolver.getResources("classpath*:/activiti/*.bpmn");
		} catch (IOException e) {
			e.printStackTrace();
		}
		processEngineConfiguration.setDeploymentResources(resources);
		processEngineConfiguration.setDeploymentMode("single-resource");
		return processEngineConfiguration;
	}
    @Bean
    public org.activiti.spring.ProcessEngineFactoryBean processEngine(org.activiti.spring.SpringProcessEngineConfiguration processEngineConfiguration) {
    	org.activiti.spring.ProcessEngineFactoryBean processEngine = new org.activiti.spring.ProcessEngineFactoryBean();
    	processEngine.setProcessEngineConfiguration(processEngineConfiguration);
        return processEngine;
    }
    @Bean
    public org.activiti.engine.RepositoryService repositoryService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getRepositoryService();
    }
    @Bean
    public org.activiti.engine.RuntimeService runtimeService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getRuntimeService();
    }
    @Bean
    public org.activiti.engine.TaskService taskService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getTaskService();
    }
    @Bean
    public org.activiti.engine.FormService formService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getFormService();
    }
    @Bean
    public org.activiti.engine.HistoryService historyService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getHistoryService();
    }
    @Bean
    public org.activiti.engine.IdentityService identityService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getIdentityService();
    }
    @Bean
    public org.activiti.engine.ManagementService managementService(org.activiti.engine.ProcessEngine processEngine){
    	return processEngine.getManagementService();
    }
</#if>    
}